#pragma once
#include "MySprite.h"
#include "Animation.h"

//Enemy inherits MySprite, this provides a framework for all enemy types, such as Goombas and Koopas

class Enemy : public MySprite
{
public:

	Enemy();
	~Enemy();

	void update(float dt);

	bool isDying();	//Get if the enemy is playing its death animation
	void setDying(bool die);	//Set the enemy to be playing its death animation

	float getDeathTime();	//Get how long it takes for the enemy's death animation to complete

protected:
	Animation* currentAnimation;

	bool dying;	//Is the enemy playing their death animation?
	float deathTime;	//How long it takes for the death animation to complete
	
};

